import { defaultFormatter } from "./default-value-formatter";

export function currencyFormatter(e: number) {
  return `$ ${Intl.NumberFormat("en-US").format(e)}`;
}

export function arraySumFormatter(arr: number[]): string {
  return defaultFormatter(arr.reduce((prefixSum, num) => prefixSum + num, 0));
}

export function percentageFormatter(number: number): string {
  return new Intl.NumberFormat('us').format(number).toString() + " %";
};

export function averageSpeedFormatter(number: number): string {
  return `${Intl.NumberFormat("en-US").format(number)}`
}

export function largeNumberFormatter(e: number) {
  let { value, append }: { value: number, append: string } = { value: 0, append: '' }

  if (e > 1000000000) {
    value = e / 1000000000
    append = 'B';
  } else if (e > 1000000) {
    value = e / 1000000
    append = 'M';
  } else if (e > 1000) {
    value = e / 1000
    append = 'K';
  } else {
    value = e
  }

  return `${Intl.NumberFormat("en-US", { maximumFractionDigits: 0 }).format(value)}${append}`;
}
